<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
include "config.php";
include "xero_token.php";

// xero webhook SIGNATURE key
$webhook_key = '77zl4oSB51lyG6toFZjZp3bIo1z+0w7nVdIu3SI52fZ06MZJlk8HoA7vb+mxZfa5RjreAzHuCowpDyb1JfapYA==';

$raw_body = file_get_contents('php://input');

$xero_signature = $_SERVER['HTTP_X_XERO_SIGNATURE'] ?? '';

$calculated_signature = base64_encode(hash_hmac('sha256', $raw_body, $webhook_key, true));

if ($xero_signature !== $calculated_signature) {

    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}



$myfile = fopen("xeroinvoiceGHL.txt", "a") or die("Unable to open file!");
$txt = $raw_body . "\n";
fwrite($myfile, $txt);
fclose($myfile);


$data = json_decode($raw_body, true);

$xero_data = isset($data['events']) ? $data['events'] : null;

if($xero_data){
    foreach($xero_data as $index => $event_data){
        if($index == 1){
            
            break;
        }
        // echo json_encode($event_data);
        // continue;
        $resourceUrl = $event_data['resourceUrl'];
        $resourceId  = $event_data['resourceId'];
        $tenantId = $event_data['tenantId'];
        $eventCategory = $event_data['eventCategory'];
        $eventType = $event_data['eventType'];
        
        if($eventCategory === 'INVOICE'){
            
            $xero_invoiceDetails = getXeroInvoice($resourceUrl);
            
            $xero_invoiceData =  $xero_invoiceDetails['Invoices'][0] ?? null;
                    
            if($xero_invoiceData){
                $xero_InvoiceNumber = $xero_invoiceData['InvoiceNumber'];
                $xero_invoice_date  = $xero_invoiceData['DateString'];
                $xero_incoice_dueDate = $xero_invoiceData['DueDateString'];
                $formatted_invoice_date = date('Y-m-d', strtotime($xero_invoice_date));
                $formatted_due_date = date('Y-m-d', strtotime($xero_incoice_dueDate));
                
                $xero_contact_name = !empty($xero_invoiceData['Contact']['Name']) ? $xero_invoiceData['Contact']['Name'] : "test jon";
                $xero_contact_firstName = !empty($xero_invoiceData['Contact']['FirstName']) ? $xero_invoiceData['Contact']['FirstName'] : "test";
                $xero_contact_lastName = !empty($xero_invoiceData['Contact']['LastName']) ? $xero_invoiceData['Contact']['LastName'] : "jon";
                $xero_contact_email = !empty($xero_invoiceData['Contact']['EmailAddress']) ? $xero_invoiceData['Contact']['EmailAddress'] : "jontest@gmail.com";
    
                $xero_invoice_status = $xero_invoiceData['Status'];
                
                $xero_currencyCode = $xero_invoiceData['CurrencyCode'];
                $xero_LineAmountTypes = $xero_invoiceData['LineAmountTypes'];
                $xero_invoice_items = $xero_invoiceData['LineItems'];
                $ghl_invoice_items=[];
                   
                foreach($xero_invoice_items as $xe_item){
                    $UnitAmount = $xe_item['UnitAmount'];
                    $Quantity = $xe_item['Quantity'];
                    $TaxType = $xe_item['TaxType'];
                    $TaxAmount = $xe_item['TaxAmount'];
                    
                    $tax_rate = calculateTaxRate($TaxAmount, $UnitAmount);
                    
                    
                    $name = $xe_item['Item']['Name'];
                    $product_id = getProductsFromGHL($name);
                    if(empty($product_id)){
                        $productData = [
                            "name" => $name,
                            "locationId" => $location_id,
                            "description" => $name,
                            "productType" => "PHYSICAL",
                            "availableInStore" => true
                        ];
                        
                        $new_product = createGHLProduct($productData);
                        echo json_encode($new_product);
                        $product_id = $new_product['_id'];
                    }
                    

                    $invoice_item=[
                        "name" => $name,
                        "productId" => $product_id,
                        "currency" => $xero_currencyCode,
                        "amount" => $UnitAmount,
                        "qty" => $Quantity
                    ];
                    
                    if($xero_LineAmountTypes == 'Exclusive' && $TaxType != 'NONE'){
                        $invoice_item['taxes']=[
                            [
                                '_id' => '67fc0da0c1a9900ad1bdfc73',
                                'name' => $TaxType,
                                'rate' => $tax_rate,
                                'calculation' => 'exclusive',
                            ]
                        ];
                    }elseif($xero_LineAmountTypes == 'Inclusive' && $TaxType != 'NONE'){
                        $invoice_item['taxes']=[
                            [
                                '_id' => '67fc0da0c1a9900ad1bdfc73',
                                'name' => $TaxType,
                                'rate' => $tax_rate,
                                'calculation' => 'inclusive',
                            ]
                        ];
                    }
                    
                    $ghl_invoice_items[] = $invoice_item;
                    // $ghl_invoice_items[]=[
                    //     "name" => $name,
                    //     "productId" => $product_id,
                    //     "currency" => $xero_currencyCode,
                    //     "amount" => $UnitAmount,
                    //     "qty" => $Quantity
                    // ];
                    
                }
                
                $ghl_contactdetails = getGhlContactByEmail($xero_contact_email);
                
                if(!empty($ghl_contactdetails['contacts'])){
                    $ghl_contactId = $ghl_contactdetails['contacts'][0]['id'];
                    $ghl_contact_name = $ghl_contactdetails['contacts'][0]['contactName'];
                    
                }else{
                    
                    $full_name = "$xero_contact_firstName $xero_contact_lastName";
                    $data = [
                        "firstName" => $xero_contact_firstName,
                        "lastName" => $xero_contact_lastName,
                        "email" => $xero_contact_email,
                        "locationId" => $location_id
                    ];
                    
                    $ghlNewContact = createGhlContact($data);
                    
                    $ghl_contactId = $ghlNewContact['contact']['id'];
                    $ghl_contact_name = $xero_contact_name;
                    
                }
                
                if($eventType == 'UPDATE'){
                    $query = "SELECT * FROM invoices WHERE xero_invoice_id = '$resourceId'";
                    $result = $conn->query($query);
                    
                    if ($result && $result->num_rows > 0) {
                        $row = $result->fetch_assoc();
                        
                        $ghl_invoiceId = $row['ghl_invoice_id'];
                        
                        $current_time = time();
                        
                        $last_sync_time = $row['last_sync_time']; 
                        
                        $updated_ghl = $row['updated_ghl'] ?? 0;
                        $updated_xero = $row['updated_xero'] ?? 0;
                        $action_for = $row['action_for'] ?? null;
                        
                        if ($updated_ghl && $updated_xero && $action_for == 'xero' && $current_time < $last_sync_time) {
                            error_log("Skipping to prevent infinite loop for GHL invoice: $ghl_invoiceId");
                            // echo "Skipping to prevent infinite loop for GHL invoice: $invoice_id";
                            http_response_code(200);
                            exit('Loop prevented');
                        }
                        // echo "test  | $current_time";
                        // exit;
                        $invoiceData = [
                            "altId" => $location_id,
                            "altType" => "location",
                            // "name" => "Invoice update from xero invoice no $xero_InvoiceNumber",
                            "name" => "New Invoice",
                            // "title" => "INVOICE",
                            "currency" => "USD",
                            "businessDetails" =>[
                                "name" => $ghl_contact_name
                                ],
                            "contactId" => $ghl_contactId,
                            "contactDetails" => [
                                "id" => $ghl_contactId,
                                "name" => $ghl_contact_name,
                                "email" => $xero_contact_email,
                            ],
                            "discount" => [],
                            "invoiceItems" => $ghl_invoice_items,
                            "issueDate" => $formatted_invoice_date,
                            "dueDate" => $formatted_due_date,
                            "liveMode" => true,
                                
                        ];
                        
                        $encodetest= json_encode($invoiceData);
                        $file = fopen("xeroinvoiceGHL.txt", "a") or die("Unable to open file!");
                            // $text = "\n New invoice store in db. \n" .$ghl_response ."\n";
                            fwrite($file, $encodetest);
                            fclose($file);
                        
                        $time = time() + 30;
                        // Update flags: GHL update initiated, Xero will act next
                        $update_query = "UPDATE invoices 
                                         SET updated_ghl = 0, 
                                             updated_xero = 1, 
                                             action_for = 'ghl', 
                                             last_sync_time = $time
                                         WHERE ghl_invoice_id = '$ghl_invoiceId'";
                        $conn->query($update_query);
                        
                        $ghl_updateResponse = updateGhlInvoice($ghl_invoiceId,$invoiceData);
                        $ghl_invoice_id = $ghl_updateResponse['_id'] ?? null;
                        if($ghl_invoice_id){
                            $update_query = "UPDATE invoices 
                                         SET updated_ghl = 1 
                                         WHERE ghl_invoice_id = '$ghl_invoiceId'";
                            $conn->query($update_query);
                        }
                        
                    }
                    
                }elseif($eventType == 'CREATE'){
                    // echo "email: $xero_contact_email";
                    // exit;
                    $invoiceData = [
                        "altId" => $location_id,
                        "altType" => "location",
                        "name" => "New Invoice",
                        // "title" => "INVOICE",
                        "currency" => $xero_currencyCode,
                        "businessDetails" =>[
                            "name" => $ghl_contact_name
                            ],
                        "contactId" => $ghl_contactId,
                        "contactDetails" => [
                            "id" => $ghl_contactId,
                            "name" => $ghl_contact_name,
                            "email" => $xero_contact_email,
                        ],
                        "discount" => [],
                        "items" => $ghl_invoice_items,
                        "issueDate" => $formatted_invoice_date,
                        "dueDate" => $formatted_due_date,
                        "sentTo" => [
                            "email" => [$xero_contact_email],
                        ],
                        "liveMode" => true,
                      
                    ];
                    
                    // echo json_encode($invoiceData);
                    // exit;
                    
                    $ghlNew_invoice = createInvoice($invoiceData);
                    
                    if($ghlNew_invoice){
                        $ghl_invoiceId = $ghlNew_invoice['_id'];
                        
                        $invoice_send = sendGHLInvoice($ghl_invoiceId);
                        // echo $invoice_send;
                        // echo "\n";
                        $ghl_response = json_encode($ghlNew_invoice);
                        echo "$ghl_response \n";
                        $stmt = $conn->prepare("INSERT INTO invoices (ghl_invoice_id,xero_invoice_id, ghl_response) VALUES (?, ?, ?)");
                        $stmt->bind_param("sss", $ghl_invoiceId, $resourceId, $ghl_response);
                            
                        if ($stmt->execute()) {
                            $file = fopen("xeroinvoiceGHL.txt", "a") or die("Unable to open file!");
                            $text = "\n New invoice store in db. \n" .$ghl_response ."\n";
                            fwrite($file, $text);
                            fclose($file);      
                        } else {
                            echo "Error storing invoice: " . $stmt->error;
                        }
                            
                        $stmt->close();
                    }
                    
                }
            }
        }
    }
    
}

function calculateTaxRate($taxAmount, $lineAmount)
{
    if ($lineAmount == 0) {
        return 0;
    }

    $rate = ($taxAmount / $lineAmount) * 100;
    return round($rate, 2); 
}

function getXeroInvoice($url) {
    global $tenant_id;
    $access_token=getTeamAccessToken();
    
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            "Authorization: Bearer $access_token",
            "Xero-tenant-id: $tenant_id",
            "Accept: application/json"
        ),
    ));

    $response = curl_exec($curl);
    
    $mfile = fopen("xeroinvoiceGHL.txt", "a") or die("Unable to open file!");
    $textdata = "\n XeroInvoice response \n" .$response . "\n";
    fwrite($mfile, $textdata);
    fclose($mfile);
    
    if (curl_errno($curl)) {
        echo 'Error: ' . curl_error($curl);
    } else {
        $data = json_decode($response, true);
    }

    curl_close($curl);
    return $data;
}

function updateGhlInvoice($invoice_id,$payload) {
    
    $url = 'https://services.leadconnectorhq.com/invoices/'.$invoice_id;
    $bearerToken = ghl_getAccessToken();
    
    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => 'PUT',
        CURLOPT_HTTPHEADER => [
            'Accept: application/json',
            'Authorization: Bearer ' . $bearerToken,
            'Content-Type: application/json',
            'Version: 2021-07-28'
        ],
        CURLOPT_POSTFIELDS => json_encode($payload),
    ]);

    $response = curl_exec($curl);

    if (curl_errno($curl)) {
        echo 'Curl Error: ' . curl_error($curl);
    } else {
        $myfile1 = fopen("xeroinvoiceGHL.txt", "a") or die("Unable to open file!");
        $txt = "\n GHL invoice update response \n" .$response . "\n";
        fwrite($myfile1, $txt);
        fclose($myfile1);
        return  json_decode($response, true);
    }

    curl_close($curl);
}

function createInvoice($data)
{   
    $bearerToken = ghl_getAccessToken();
    
    $url = 'https://services.leadconnectorhq.com/invoices/';

    $headers = [
        'Accept: application/json',
        'Authorization: Bearer '.$bearerToken,
        'Content-Type: application/json',
        'Version: 2021-07-28',
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POST, true);

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        return 'Curl error: ' . curl_error($ch);
    }

    curl_close($ch);
    return json_decode($response, true);
}

function sendGHLInvoice($invoiceId) {
    global $location_id;
    global $user_id;
    $accessToken = ghl_getAccessToken();
    $url = "https://services.leadconnectorhq.com/invoices/{$invoiceId}/send";

    $payload = [
        "altId" => $location_id,
        "altType" => "location",
        "userId" => $user_id,
        "action" => "email",
        "liveMode" => true,
    ];

    $headers = [
        "Accept: application/json",
        "Authorization: Bearer $accessToken",
        "Content-Type: application/json",
        "Version: 2021-07-28"
    ];

    $ch = curl_init($url);

    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    }

    curl_close($ch);

    return $response;
}


function getGhlContactByEmail($email) {
    global $location_id;
    $accessToken = ghl_getAccessToken();
    $url = "https://services.leadconnectorhq.com/contacts/?locationId=" . urlencode($location_id) . "&query=" . urlencode($email);

    $headers = [
        "Accept: application/json",
        "Authorization: Bearer $accessToken",
        "Version: 2021-07-28"
    ];

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => $headers
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        return ["error" => $err];
    }

    return json_decode($response, true);
}

function createGhlContact($data) {
    // global $location_id;
    $accessToken = ghl_getAccessToken();

    $url = 'https://services.leadconnectorhq.com/contacts/';

    $headers = [
        "Accept: application/json",
        "Authorization: Bearer $accessToken",
        "Content-Type: application/json",
        "Version: 2021-07-28"
    ];
    
    $ch = curl_init($url);
    
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_errno($ch)) {
        return 'Request Error:' . curl_error($ch);
    }
    // echo $response;
    // exit;
    curl_close($ch);

    return json_decode($response, true);
}

function getProductsFromGHL($searchTerm) {
    global $location_id;
    $accessToken = ghl_getAccessToken();
    $url = "https://services.leadconnectorhq.com/products/?locationId=" . urlencode($location_id) . "&search=" . urlencode($searchTerm);

    $headers = [
        "Accept: application/json",
        "Authorization: Bearer {$accessToken}",
        "Version: 2021-07-28"
    ];

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => $headers,
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {
        return ["error" => $err];
    } 
    
    $data = json_decode($response, true);
    
    if($data['products']){
        $product_id = $data['products'][0]['_id'];
        return $product_id;
    }else{
        return null;
    }
}

function createGHLProduct($productData) {
    $accessToken = ghl_getAccessToken();
    $url = "https://services.leadconnectorhq.com/products/";

    $headers = [
        "Accept: application/json",
        "Authorization: Bearer {$accessToken}",
        "Content-Type: application/json",
        "Version: 2021-07-28"
    ];

    $payload = json_encode($productData);

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $payload,
        CURLOPT_HTTPHEADER => $headers,
    ]);

    $response = curl_exec($curl);
    $error = curl_error($curl);

    curl_close($curl);

    if ($error) {
        return ["error" => $error];
    }

    return json_decode($response, true);
}


// http_response_code(200);
// echo json_encode(['status' => 'Webhook received']);
exit;