<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
include "config.php";
include "xero_token.php";

$postData = file_get_contents('php://input');

$myfile = fopen("GhlInvoiceMtoX.txt", "a") or die("Unable to open file!");
$txt = $postData . "\n";
fwrite($myfile, $txt);
fclose($myfile);


$data = json_decode($postData,true);

$invoice_items=$data['invoice']['_data']['invoiceItems'];
$invoice_status = $data['invoice']['_data']['status'];
$invoice_id = $data['invoice']['_id'];
// $invoiceNumber = $data['invoice']['invoiceNumber'];
$invoice_due_date= $data['invoice']['_data']['dueDate'];
$invoice_issue_date = $data['invoice']['_data']['issueDate'];
$formatted_isseu_date = date('Y-m-d', strtotime($invoice_issue_date));
$formatted_due_date = date('Y-m-d', strtotime($invoice_due_date));
$custom_items=[];
$LineAmountTypes = 'NoTax';
foreach($invoice_items as $item){
    $name = $item['name'];
    $qty = $item['qty'];
    $amount = $item['amount'];
    $description = !empty($item['description']) ? $item['description'] : $name;
    
    $total_tax=0;
    $taxes = $item['taxes'];
    
    if (isset($item['taxes']) && is_array($item['taxes']) && !empty($item['taxes'])) {
        foreach ($item['taxes'] as $tax) {
            // Calculate tax based on the rate and whether it's inclusive or exclusive
            if ($tax['calculation'] == 'exclusive') {
                $LineAmountTypes = 'Exclusive';
                // Tax is added on top of the amount
                $total_tax += ($amount * $qty) * ($tax['rate'] / 100);
            } elseif($tax['calculation'] == 'inclusive') {
                $LineAmountTypes = 'Inclusive';
                // Tax is included in the amount - need to calculate the tax portion
                // Formula: tax = (amount * rate) / (100 + rate)
                $total_tax += (($amount * $qty) * $tax['rate']) / (100 + $tax['rate']);
            }
        }
    }
    
    $xero_itemCode = getItemCodeByName($name);

    if (!$xero_itemCode) {
        $converted_name = convertToSlug($name);
        $xeroNewItem = [
            "Code" => $converted_name,
            "Name" => $name,
            "Description" => $description
        ];
        $xero_itemCode = createXeroItem($xeroNewItem);
    }

    // $custom_items[] = [
    //     "Description" => $description,
    //     "Quantity" => $qty,
    //     "UnitAmount" => $amount,
    //     "ItemCode" => $xero_itemCode ,
    //     "AccountCode" => $account_code,
    //     // "AccountId" => $account_id,
    //     // "TaxType" => "OUTPUT",
    //     // "TaxAmount" => $total_tax
    // ];
    
    // if($LineAmountTypes != "NoTax"){
    //     $custom_items['TaxType'] = "OUTPUT";
    //     $custom_items['TaxAmount'] = $total_tax;
    // }
    $line_item = [
        "Description" => $description,
        "Quantity" => $qty,
        "UnitAmount" => $amount,
        "ItemCode" => $xero_itemCode,
        "AccountCode" => $account_code,
    ];

    if ($LineAmountTypes !== 'NoTax') {
        $line_item["TaxType"] = "OUTPUT";
        $line_item["TaxAmount"] = $total_tax;
    }

    $custom_items[] = $line_item;
}

$custom_data=[
        "ghl_contact_id" => $data['contact_id'],
        "ghl_invoice_id" => $invoice_id,
        "first_name" => $data['first_name'] ?? 'n/a',
        "last_name" => $data['last_name'] ?? 'n/a',
        "full_name" => $data['full_name'] ?? 'n/a',
        "email" => $data['email'],
        "location_name" => $data['location']['name'],
        "location_id" => $data['location']['id'],
        "LineItems" => $custom_items,
        "issue_date" => $formatted_isseu_date,
        "due_date" => $formatted_due_date,
        "lineAmountTypes" => $LineAmountTypes,
    ];

$query = "SELECT * FROM invoices WHERE ghl_invoice_id = '$invoice_id'";
$result = $conn->query($query);
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $xero_invoice_id = $row['xero_invoice_id'] ?? null;
    $current_time = time();
    
    $last_sync_time = $row['last_sync_time']; // default fallback
    
    $updated_ghl = $row['updated_ghl'] ?? 0;
    $updated_xero = $row['updated_xero'] ?? 0;
    $action_for = $row['action_for'] ?? null;
    // echo "$updated_ghl | $updated_xero \n";
    
    if ($updated_ghl && $updated_xero && $action_for == 'ghl' && $current_time < $last_sync_time) {
        error_log("Skipping to prevent infinite loop for GHL invoice: $invoice_id");
        // echo "Skipping to prevent infinite loop for GHL invoice: $invoice_id";
        http_response_code(200);
        exit('Loop prevented');
    }
    
    if($xero_invoice_id){
        $custom_data['xero_invoice_id'] = $xero_invoice_id;
        $custom_data['isUpdate'] = true;
        $time = time() + 30;
        // Update flags: GHL update initiated, Xero will act next
        $update_query = "UPDATE invoices 
                         SET updated_ghl = 1, 
                             updated_xero = 0, 
                             action_for = 'xero', 
                             last_sync_time = $time
                         WHERE ghl_invoice_id = '$invoice_id'";
        $conn->query($update_query);
        // exit;
    }else{
        $custom_data['isUpdate'] = false;
    }
    
    if($invoice_status == "sent"){
        $custom_data['isSent'] = true;
    }else{
        $custom_data['isSent'] = false;
    }
    
    send_dataTo_make($custom_data);
    
}else{
    // Store data in database
    $stmt = $conn->prepare("INSERT INTO invoices (ghl_invoice_id, ghl_response) VALUES (?, ?)");
    $stmt->bind_param("ss", $invoice_id, $postData);
        
    if ($stmt->execute()) {
        echo "New invoice store in db.";       
    } else {
        echo "Error storing invoice: " . $stmt->error;
    }
        
    $stmt->close();
    
    $custom_data['isUpdate'] = false;
    
    if($invoice_status == "sent"){
        $custom_data['isSent'] = true;
    }else{
        $custom_data['isSent'] = false;
    }
    
    send_dataTo_make($custom_data);
}



function getItemCodeByName($item_name) {
    global $tenant_id;
    $access_token=getTeamAccessToken();
    
    $url = 'https://api.xero.com/api.xro/2.0/Items?where=' . urlencode('Name=="' . $item_name . '"');

    $headers = [
        'Authorization: Bearer ' . $access_token,
        'Xero-tenant-id: ' . $tenant_id,
        'Accept: application/json'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Curl error: ' . curl_error($ch);
        return false;
    }

    curl_close($ch);

    $data = json_decode($response, true);
    
    if(!empty($data['Items'])){
        $item_code = $data['Items'][0]['Code'];
        return $item_code;
    }else{
        return null;
    }
}

function createXeroItem($data) {
    
    global $tenant_id;
    $access_token=getTeamAccessToken();
    
    $url = "https://api.xero.com/api.xro/2.0/Items";

    $headers = [
        "Authorization: Bearer $access_token",
        "Xero-tenant-id: $tenant_id",
        "Content-Type: application/json",
        "Accept: application/json"
    ];

    $jsonData = json_encode($data);

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

    $response = curl_exec($ch);
    $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_errno($ch)) {
        echo 'Curl error: ' . curl_error($ch);
    }

    curl_close($ch);

    if($http_status == 200){
        $item_data = json_decode($response, true);
        $item_code = $item_data['Items'][0]['Code'];
        return $item_code;
    }else{
        // echo $response;
        return null;
    }
    
}

function convertToSlug($string) {
    // Convert to lowercase
    $slug = strtolower($string);
    
    // Replace spaces and underscores with dash
    $slug = preg_replace('/[\s_]+/', '-', $slug);
    
    // // Remove all non-alphanumeric characters except dash
    // $slug = preg_replace('/[^a-z0-9\-]/', '', $slug);
    
    // Trim dashes from ends
    $slug = trim($slug, '-');
    return $slug;
}

function send_dataTo_make($custom_data){
    // Send POST request to Make webhook
    $webhook_url = "https://hook.us2.make.com/v8psy2d5uxo5xhnjzgpaojbsrvtl0itv";
    
    $ch = curl_init($webhook_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($custom_data));
    
    $response = curl_exec($ch);
    
    if (curl_errno($ch)) {
        echo 'Error sending data to webhook: ' . curl_error($ch);
    } else {
        
        $myfile1 = fopen("GhlInvoiceMtoX.txt", "a") or die("Unable to open file!");
        $txt1 = "Make data received status:" .$response . "\n";
        fwrite($myfile1, $txt1);
        fclose($myfile1);
    }
    
    curl_close($ch);

}



