<?php

include "config.php";

if (!isset($_GET['code'])) {
    die("Authorization code not found.");
    
    // $encoded_uri = urlencode($redirect_uri);

    // $scope_string = urlencode(implode(' ', $scopes));
    
    // // Build the URL
    // $auth_url = "https://marketplace.leadconnectorhq.com/oauth/chooselocation?"
    //           . "response_type=code"
    //           . "&redirect_uri=$encoded_uri"
    //           . "&client_id=$client_id"
    //           . "&scope=$scope_string";
    
    // // Redirect to OAuth URL
    // header("Location: $auth_url");
    // exit;
}

$auth_code = $_GET['code'];

GHL_oauth($auth_code);


function GHL_oauth($auth_code){
    
    global $client_id;
    global $client_secret;
    global $redirect_uri;
    global $conn;
    
    $url = 'https://services.leadconnectorhq.com/oauth/token';
    $data = [
        'client_id' => $client_id,
        'client_secret' => $client_secret,
        'grant_type' => 'authorization_code',
        'code' => $auth_code,
        'redirect_uri' => $redirect_uri
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: application/json',
        'Content-Type: application/x-www-form-urlencoded'
    ]);
    
    $response = curl_exec($ch);
    
    if (curl_errno($ch)) {
        echo 'Error: ' . curl_error($ch);
    }
    
    curl_close($ch);
    
    $data = json_decode($response, true);
    
    if (isset($data['access_token'])) {
        $accessToken = $data['access_token'];
        $refreshToken = $data['refresh_token'];
        $locationId = $data['locationId'];
        // $companyId = $data['companyId'];
        // $userId = $data['userId'];
        // $user_type = $data['userType'];
        $expires_in = $data['expires_in'];
        $expires_time = time() + $expires_in;
        
        // Store tokens in database
        $stmt = $conn->prepare("INSERT INTO GHL_token (access_token, refresh_token, expires_in, expires_time, location_id) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("sssss", $accessToken, $refreshToken, $expires_in, $expires_time, $locationId);
        
        if ($stmt->execute()) {
            echo "Tokens stored successfully.";          
        } else {
            echo "Error storing tokens: " . $stmt->error;
        }
        
        $stmt->close();
    } else {
        echo "Error: Invalid response from API.";
    }
}